<?php
/*
Plugin Name: Bundle Plugin
Description: A plugin to manage bundled products in WooCommerce.
Version: 1.04
Author: SPC
License: Commercial
*/

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Block XML-RPC
add_filter('xmlrpc_enabled', '__return_false');

// Include required files
include_once plugin_dir_path(__FILE__) . 'includes/class-add-bundle-fields.php';
include_once plugin_dir_path(__FILE__) . 'includes/class-save-bundle-fields.php';
include_once plugin_dir_path(__FILE__) . 'includes/class-bundle-scripts.php';
include_once plugin_dir_path(__FILE__) . 'includes/class-bundle-ajax.php';
include_once plugin_dir_path(__FILE__) . 'includes/class-bundle-stock-reduction.php';
include_once plugin_dir_path(__FILE__) . 'includes/class-plugin-security.php';

// Initialize the classes
new Add_Bundle_Fields();
new Save_Bundle_Fields();
new Bundle_Scripts();
new Bundle_AJAX();
new Bundle_Stock_Reduction();
new Plugin_Security();
