<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Save_Bundle_Fields {
    public function __construct() {
        add_action('woocommerce_process_product_meta', array($this, 'save_bundle_fields_for_all_products'));
    }

    public function save_bundle_fields_for_all_products($post_id) {
        $is_bundle = isset($_POST['_is_bundle']) ? 'yes' : 'no';
        update_post_meta($post_id, '_is_bundle', esc_attr($is_bundle));

        $total_price = 0;

        if ($is_bundle === 'yes') {
            for ($i = 1; $i <= 4; $i++) {
                $product_id = intval($_POST['bundle_product_id_' . $i]);
                $product_quantity = intval($_POST['bundle_product_qty_' . $i]) ?: 1;

                if (!empty($product_id)) {
                    update_post_meta($post_id, '_bundle_product_' . $i, esc_attr($product_id));
                    update_post_meta($post_id, '_bundle_product_qty_' . $i, esc_attr($product_quantity));
                    $product = wc_get_product($product_id);
                    $total_price += $product->get_price() * $product_quantity;
                } else {
                    delete_post_meta($post_id, '_bundle_product_' . $i);
                    delete_post_meta($post_id, '_bundle_product_qty_' . $i);
                }
            }

            if ($total_price > 0) {
                update_post_meta($post_id, '_price', esc_attr($total_price));
                update_post_meta($post_id, '_regular_price', esc_attr($total_price));
            }
        }
    }
}
