<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Bundle_Stock_Reduction {
    public function __construct() {
        add_action('woocommerce_order_status_completed', array($this, 'reduce_bundle_product_stock'));
    }

    public function reduce_bundle_product_stock($order_id) {
        $order = wc_get_order($order_id);

        foreach ($order->get_items() as $item) {
            $product_id = intval($item->get_product_id());
            $is_bundle = get_post_meta($product_id, '_is_bundle', true);

            if ($is_bundle === 'yes') {
                $bundle_items = array();

                for ($i = 1; $i <= 4; $i++) {
                    $bundle_product_id = intval(get_post_meta($product_id, '_bundle_product_' . $i, true));
                    $bundle_quantity = intval(get_post_meta($product_id, '_bundle_product_qty_' . $i, true)) ?: 1;

                    if ($bundle_product_id) {
                        $bundle_items[] = array(
                            'product_id' => $bundle_product_id,
                            'quantity' => $bundle_quantity * $item->get_quantity()
                        );
                    }
                }

                foreach ($bundle_items as $bundle_item) {
                    $bundle_product = wc_get_product($bundle_item['product_id']);
                    $new_stock = $bundle_product->get_stock_quantity() - $bundle_item['quantity'];

                    if ($new_stock < 0) {
                        $new_stock = 0;
                    }

                    wc_update_product_stock($bundle_product, $new_stock);
                    $bundle_product->save();
                }
            }
        }
    }
}
