<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Bundle_Scripts {
    public function __construct() {
        add_action('admin_enqueue_scripts', array($this, 'bundle_product_enqueue_scripts'));
    }

    public function bundle_product_enqueue_scripts() {
        wp_enqueue_script('jquery-ui-autocomplete');
        wp_enqueue_script('bundle-product-search', plugin_dir_url(__FILE__) . '../assets/js/bundle-product-search.js', array('jquery', 'jquery-ui-autocomplete'), null, true);
        wp_enqueue_script('bundle-custom-js', plugin_dir_url(__FILE__) . '../assets/js/bundle-custom-js.js', array('jquery'), null, true);
        wp_localize_script('bundle-product-search', 'bundleProductSearch', array(
            'ajax_url' => admin_url('admin-ajax.php'),
        ));
    }
}
