<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Bundle_AJAX {
    public function __construct() {
        add_action('wp_ajax_bundle_product_search', array($this, 'bundle_product_search'));
        add_action('wp_ajax_get_product_image', array($this, 'get_product_image_and_price'));
    }

    public function bundle_product_search() {
        $search_term = sanitize_text_field($_GET['term']);
        $args = array(
            's' => $search_term,
            'post_type' => 'product',
            'posts_per_page' => 10,
        );

        $products = get_posts($args);
        $suggestions = array();

        foreach ($products as $product) {
            $suggestions[] = array(
                'label' => esc_html($product->post_title),  // Secure output with esc_html
                'value' => intval($product->ID),  // Secure output with intval
            );
        }

        wp_send_json($suggestions);
    }

    public function get_product_image_and_price() {
        $product_id = intval($_GET['product_id']);
        $image = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'thumbnail');
        $price = strip_tags(wc_price(wc_get_product($product_id)->get_price()));

        wp_send_json(array(
            'image' => $image ? esc_url($image[0]) : '',  // Secure output with esc_url
            'price' => esc_html($price),  // Secure output with esc_html
        ));
    }
}
