<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

class Add_Bundle_Fields {
    public function __construct() {
        add_action('woocommerce_product_options_general_product_data', array($this, 'add_bundle_fields_to_all_products'));
    }

    public function add_bundle_fields_to_all_products() {
        global $post;

        echo '<div class="options_group">';
        woocommerce_wp_checkbox(array(
            'id' => '_is_bundle',
            'label' => __('Bundle'),
            'description' => __('Enable bundle functionality for this product.'),
            'value' => get_post_meta($post->ID, '_is_bundle', true),
        ));
        echo '</div>';

        echo '<div id="bundle_fields_container" class="options_group" style="display:none;">';
        for ($i = 1; $i <= 4; $i++) {
            $product_id = get_post_meta($post->ID, '_bundle_product_' . $i, true);
            $product_name = $product_id ? esc_html(get_the_title($product_id)) : '';  // Secure output with esc_html
            $product_image = $product_id ? esc_url(wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'thumbnail')[0]) : '';  // Secure output with esc_url
            $product_price = $product_id ? strip_tags(wc_price(wc_get_product($product_id)->get_price())) : '';  // Secure output with strip_tags
            $product_quantity = intval(get_post_meta($post->ID, '_bundle_product_qty_' . $i, true)) ?: 1;  // Secure output with intval

            echo '<p class="form-field bundle-product-field">
                    <label for="bundle_product_' . $i . '">' . __( 'Bundle Product ' . $i ) . '</label>
                    <input type="text" class="bundle_product_search" id="bundle_product_' . $i . '" name="bundle_product_' . $i . '" value="' . esc_attr($product_name) . '" />
                    <input type="hidden" id="bundle_product_id_' . $i . '" name="bundle_product_id_' . $i . '" value="' . esc_attr($product_id) . '" />
                    <span class="bundle-product-image">' . ($product_image ? '<img src="' . esc_attr($product_image) . '" style="width: 30px; height: 30px;" />' : '') . '</span>
                    <span class="bundle-product-price">' . esc_html($product_price) . '</span>
                    <input type="number" class="bundle-product-quantity" name="bundle_product_qty_' . $i . '" value="' . esc_attr($product_quantity) . '" min="1" style="width: 60px;" />
                    <button type="button" class="button remove-bundle-product" style="display: ' . ($product_id ? 'inline-block' : 'none') . ';">' . __('Remove') . '</button>
                    <button type="button" class="button save-bundle-product" style="display: ' . ($product_id ? 'inline-block' : 'none') . ';">' . __('Save') . '</button>
                    <span class="description">' . __( 'Select a product to include in the bundle' ) . '</span>
                </p>';
        }
        echo '</div>';
    }
}
