jQuery(document).ready(function($) {
    $('.bundle_product_search').autocomplete({
        source: function(request, response) {
            $.ajax({
                url: bundleProductSearch.ajax_url,
                dataType: 'json',
                data: {
                    term: request.term,
                    action: 'bundle_product_search'
                },
                success: function(data) {
                    response($.map(data, function(item) {
                        return {
                            label: item.label,
                            value: item.value
                        };
                    }));
                }
            });
        },
        minLength: 3,
        select: function(event, ui) {
            $(this).val(ui.item.label);
            $(this).next('input[type=hidden]').val(ui.item.value);
            updateProductImageAndPrice($(this), ui.item.value);
            $(this).siblings('.remove-bundle-product').show();
            $(this).siblings('.save-bundle-product').show();
            return false;
        }
    });
});
