jQuery(document).ready(function($) {
    function updateTotalPrice() {
        var totalPrice = 0;
        $('.bundle-product-field').each(function() {
            var productPrice = parseFloat($(this).find('.bundle-product-price').text().replace(/[^0-9.-]+/g, ""));
            var quantity = parseInt($(this).find('.bundle-product-quantity').val());
            if (!isNaN(productPrice) && !isNaN(quantity)) {
                totalPrice += productPrice * quantity;
            }
        });
        $('#_regular_price').val(totalPrice.toFixed(2));
    }

    updateTotalPrice();
    $('.bundle-product-field .bundle-product-quantity').on('input', function() {
        updateTotalPrice();
    });
    $('.bundle_product_search').on('autocompleteselect', function() {
        updateTotalPrice();
    });

    function toggleBundleFields() {
        if ($('#_is_bundle').is(':checked')) {
            $('#bundle_fields_container').show();
            updateTotalPrice();
        } else {
            $('#bundle_fields_container').hide();
            $('#_regular_price').val(''); // Reset the price if bundle is disabled
        }
    }

    toggleBundleFields();

    $('#_is_bundle').change(function() {
        toggleBundleFields();
    });
});
